import numpy as np


def sigmoid(s):
    return 1 / (1 + np.exp(-s))


# def sigmoid(s):
#     if s>=0:
#         return 1/(1 + np.exp(-s))
#     else:
#         return np.exp(s)/(1+np.exp(s))


def construct_f_deterministic(x, y, lamda, alpha):
    def f(w):
        loss = 0
        for i in range(len(y)):
            loss = loss + (y[i] - sigmoid(np.dot(w, x[0, :])))**2 / len(y)
        regularizer = 0
        for j in range(len(w)):
            regularizer = regularizer + (lamda * w[j]**2) / (1 + alpha * w[j]**2)
        return loss + regularizer
    return f


def construct_f_stochastic(x, y, lamda, alpha):
    def f(w, index):
        loss = 0
        for i in range(len(index)):
            loss = loss + (np.array(y[index[i]]) - sigmoid(np.dot(w, np.array(x[index[i], :]))))**2 / len(index)
        regularizer = 0
        for j in range(len(w)):
            regularizer = regularizer + (lamda * w[j]**2) / (1 + alpha * w[j]**2)
        return loss + regularizer
    return f


